using System;
using Habanero.BO;

namespace BobsPizzaPlace.BO
{
    public class OrderItem : BusinessObject
    {
        public virtual Pizza Pizza
        {
            get { return Relationships.GetRelatedObject<Pizza>("Pizza"); }
            set { Relationships.SetRelatedObject("Pizza", value); }
        }

        public virtual int NumberOfItems
        {
            get { return ((int)(base.GetPropertyValue("NumberOfItems"))); }
            set { base.SetPropertyValue("NumberOfItems", value); }
        }

        public decimal Subtotal
        {
            get { return this.Pizza.Price*NumberOfItems; }
        }
    }
}